/*
 * ============================================================================
 *
 *  [THC RPG] Total HardCore RPG
 *
 *  File:          project.inc
 *  Type:          Base
 *  Description:   Contains defines, enums, etc available to anywhere in the project.
 *
 *  Copyright (C) 2009-2011  ArsiRC
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ============================================================================
 */

/**
 * Add defines for supported games here.
 * Uncomment, or add a define for the game you are compiling for here.
 */
#define PROJECT_GAME_CSS
//#define PROJECT_GAME_DOD
//#define PROJECT_GAME_HL2DM
//#define PROJECT_GAME_TF2
//#define PROJECT_GAME_L4D
//#define PROJECT_GAME_L4D2

/**
 * Additional includes.
 * Include files like sdktools.inc here.
 */
#include <sdktools>

/**
 * Global Defines
 */
// Vector position defines
#define VECTOR_PLAYERS_CLIENT 0
#define VECTOR_PLAYERS_ID 1
#define VECTOR_PLAYERS_XP 2
#define VECTOR_PLAYERS_REQXP 3
#define VECTOR_PLAYERS_LEVEL 4
#define VECTOR_PLAYERS_CREDITS 5
// Others
#define CONFIG_MAX_KEYS 64
//
#define CSS_TEAM_T				2	//Terrorists
#define CSS_TEAM_CT				3	//Counter-Terrorists
#define CSS_SLOT_PRIMARY		0	//Primary weapon slot
#define CSS_SLOT_SECONDARY		1	//Secondary weapon slot
#define CSS_SLOT_KNIFE			2	//Knife slot
#define CSS_SLOT_GRENADE		3	//Grenade slot
#define CSS_MAX_WEAPONSLOTS     4


/**
 * Global Enums
 */
enum CoreConfigs
{
    String:CoreConfig_admin_flags[32],
    String:CoreConfig_vip_flags[32],
    CoreConfig_bot_enable,
    CoreConfig_bot_control,
    CoreConfig_bot_maxlevel,
    CoreConfig_exp_max,
    CoreConfig_exp_start,
    CoreConfig_exp_inc,
    CoreConfig_exp_kill,
    CoreConfig_exp_headshot,
    Float:CoreConfig_exp_damage,
    Float:CoreConfig_exp_knifedmg,
    CoreConfig_exp_objectives,
	CoreConfig_exp_mode,
    Float:CoreConfig_exp_teamwin,
    Float:CoreConfig_exp_bombplanted,
    Float:CoreConfig_exp_bombdefused,
    Float:CoreConfig_exp_bombexploded,
    Float:CoreConfig_exp_hostage,
    CoreConfig_credits_inc,
    CoreConfig_credits_start,
    Float:CoreConfig_save_percent,
    CoreConfig_advert,
    CoreConfig_announcements,
    CoreConfig_freeforall,
    CoreConfig_maxspawnhp,
    String:CoreConfig_sound_error[64],
    String:CoreConfig_sound_reset[64],
    String:CoreConfig_sound_purchase[64],
    String:CoreConfig_sound_sell[64]
}

enum UpgradeConfigs
{
    UpgradeConfig_Disable,
    UpgradeConfig_TeamLock,
    UpgradeConfig_Effects,
    UpgradeConfig_MaxLevel,
    UpgradeConfig_Cost,
    UpgradeConfig_iCost,
    Float:UpgradeConfig_Interval,
    UpgradeConfig_MinAlpha,
    Float:UpgradeConfig_Percent,
    Float:UpgradeConfig_Amount,
    UpgradeConfig_Suicide,
    UpgradeConfig_Unlimited,
    UpgradeConfig_Mode,
    UpgradeConfig_TotalFreeze,
    String:UpgradeConfig_Sound[64]
}

/**
 * Global Variables
 */
new Handle:g_hVecPlayers;
new Handle:g_hSQL;
new g_CoreConfigCache[CoreConfigs];
new g_iColorOffset;
new g_iGetVelocityOffset_0;
new g_iGetVelocityOffset_1;
new g_iBaseVelocityOffset;
new g_iActiveWeaponOffset;
new g_iWeaponClipOffset;
new g_iArmorOffset;
new g_iAmmoOffset;
new g_iClientSpawnHealth[MAXPLAYERS+1];
new Float:g_fClientSpawnSpeed[MAXPLAYERS+1];
new g_iClientModifiedHealth[MAXPLAYERS+1];
new Float:g_fClientModifiedSpeed[MAXPLAYERS+1];
new g_iGameframes;

/**
 * Modules for interlocks and dependencies
 */
new Module:g_moduleCore;
new Module:g_modulefrostp;
new Module:g_modulefirep;
new Module:g_modulefrostnade;
new Module:g_modulefirenade;

/**
 * This is where it all begins.
 * Forward the OnPluginStart event here to all modules so they can register.
 */
stock ForwardOnPluginStart()
{
    // Forward event to non-modules.
    
    // Forward the OnPluginStart event to all modules here.
    Core_Register();
    // Upgrades
    // speed upgrades
    speed_Register();
    adren_Register();
    impulse_Register();
    // health upgrades
    health_Register();
    medic_Register();
    regen_hp_Register();
    vampire_Register();
    // others
    bouncyb_Register();
    damage_Register();
    firenade_Register();
    frostnade_Register();
    firep_Register();
    frostp_Register();
    gravity_Register();
    icestab_Register();
    longjump_Register();
    mirrordmg_Register();
    poisonsm_Register();
    posswap_Register();
    regen_ammo_Register();
    regen_armor_Register();
    regen_gren_Register();
    stealth_Register();
}

// **********************************************
//                   Reference
// **********************************************

/**
 * The client index of the server.
 */
#define SERVER_INDEX 0

/**
 * Generic enum for specifying whether this should apply to the server or the client.
 */
enum CommandFor
{
    CommandFor_Server,
    CommandFor_Client
}

// **********************************************
//                Module Manager
// **********************************************

/**
 * The amount of registered modules.
 * All integers less than this (and greater than or equal to zero) are valid module identifiers.
 */
#define MODULE_COUNT GetArraySize(ModuleMgr_GetList())

/**
 * Takes either a module ID or module identifier and converts it to its respective opposite.
 */
#define MODULE_TO_ID(%1) _:%1 + 1
#define ID_TO_MODULE(%1) Module:(%1 - 1)

/**
 * Module identifier tag.
 */
enum Module
{
    INVALID_MODULE = -1     /** Used as an invalid module. */
}

/**
 * Module data flags.
 */
#define MODULE_DATA_DISABLED    (1 << 0)
#define MODULE_DATA_HIDDEN      (1 << 1)
#define MODULE_DATA_FULLNAME    (1 << 2)
#define MODULE_DATA_SHORTNAME   (1 << 3)
#define MODULE_DATA_DESCRIPTION (1 << 4)
#define MODULE_DATA_DEPENDENCIES (1 << 5)
#define MODULE_DATA_INTERLOCKS  (1 << 6)
#define MODULE_DATA_TEAMLOCK    (1 << 7)
#define MODULE_DATA_MAXLEVEL    (1 << 8)
#define MODULE_DATA_COST        (1 << 9)
#define MODULE_DATA_ICOST       (1 << 10)
/**
 * The max string/array lengths of module data variables.
 */
#define MM_DATA_FULLNAME        64
#define MM_DATA_SHORTNAME       32
#define MM_DATA_DESCRIPTION     256
#define MM_DATA_DEPENDENCIES    32
#define MM_DATA_INTERLOCKS      32

/**
 * All the data modules need to register.
 */
enum ModuleData
{
    bool:ModuleData_Disabled = 0,                           /** True if the module is disabled. */
    bool:ModuleData_Hidden,                                 /** True to hide the module from console. (base cmd can't touch it) */
    String:ModuleData_FullName[MM_DATA_FULLNAME],           /** Used for displaying modules. */
    String:ModuleData_ShortName[MM_DATA_SHORTNAME],         /** Used for client interaction with modules. */
    String:ModuleData_Description[MM_DATA_DESCRIPTION],     /** A description of the module */
    Module:ModuleData_Dependencies[MM_DATA_DEPENDENCIES],   /** An array of module IDs that the module depends on.  {INVALID_MODULE} = no dependencies.  Must end with INVALID_MODULE. */
    Module:ModuleData_Interlocks[MM_DATA_INTERLOCKS],       /** An array of module IDs that locks the module if level>0.  {INVALID_MODULE} = no dependencies.  Must end with INVALID_MODULE. */
    any:ModuleData_TeamLock,
    any:ModuleData_MaxLevel,
    any:ModuleData_Cost,
    any:ModuleData_iCost
}

/**
 * Return values for ModuleMgr_Enable/Disable
 */
enum ModuleToggleQuery
{
    ToggleQuery_Successful,     /** The module was successfully enabled/disabled. */
    ToggleQuery_Stopped,        /** The query was stopped because it was redundant. (already enabled/disabled) */
    ToggleQuery_Refuse,         /** A module refused to enable/disable without a refusal message. */
    ToggleQuery_RefuseWithMsg,  /** A module refused to enable/disable and printed a refusal message. */
    ToggleQuery_Dependent,      /** Enable - The module couldn't be loaded because at least one dependency isn't loaded. */
                                /** Disable - Other dependent modules were disabled as a result of this module being disabled. */
}

/**
 * The longest string that can be stored in the module's data.
 */
#define MODULE_DATA_LONGEST_STRING 256

// **********************************************
//                 Event Manager
// **********************************************
// Note: Ignore this section if eventmanager.inc isn't included in the project.
// Look in project_events.inc to setup and hook all events your project will need.

// **********************************************
//                    General
// **********************************************

/**
 * Basic project information.  This will also be displayed in 'sm plugins *' commands.
 */

// Used when printing the plugin name anywhere.
#define PROJECT_FULLNAME    "[THC RPG] Total HardCore RPG"
#define PROJECT_PRINT_FULLNAME    "THC RPG"

// Shorter version of the full name, used in file paths, and other things.
#define PROJECT_SHORTNAME   "thc_rpg"

// Author of the plugin.
#define PROJECT_AUTHOR      "ArsiRC"

// Description of the plugin.
#define PROJECT_DESCRIPTION "Earn XP to level up and receive credits to buy upgrades"

// http://wiki.eclipse.org/Version_Numbering
#define PROJECT_VERSION     "0.8.3_stable"

// Any URL associated with the project.
#define PROJECT_URL "http://code.google.com/p/thc-rpg"

/**
 * Additional information displayed in the version info.
 */
#define PROJECT_COPYRIGHT "Copyright (C) 2009-2011  ArsiRC"
#define PROJECT_LICENSE "GNU GPL, Version 3"

/**
 * Credits.
 * This is the exact string that's printed to the server/client.
 * Feel free to change it to anything, but the names mentioned here by default, should be credited somewhere.
 */
#define PROJECT_CREDITS " Plugin was developed by ArsiRC.\n Development would not have been possible without:\n  AlliedModders, LLC.\n  Andrew \"Greyscale\" Borba, plugin base developer\n  Richard \"rhelgeby\" Helgeby, compilation environment designer and advisor\n Special thanks to SumGuy14 (Aka SoccerDude), developer of RPGx CSS\n http://www.sourcemod.net/"

/**
 * Base file message prefixes.
 * 
 * See Project_PrintToServer in wrappers.inc.
 * 'formatted': The text being printed.
 */
#define PROJECT_SERVER_PREFIX "[%s] %s", PROJECT_PRINT_FULLNAME, formatted

/**
 * Your plugin's base command for module management.
 * This command will be very similar to the "sm" command except geared toward module management instead of plugin management.
 * Also handles printing plugin information like credits and version.
 * Comment out to remove command from the plugin.
 */
#define PROJECT_BASE_CMD PROJECT_SHORTNAME

/**
 * The prefixes for any base cvars/commands.
 * These are strictly for project base cvars/commands.
 * This will not affect cvars/commands created in your modules.
 * Note: See wrappers.inc for stocks that allow you to create cvars/commands with these prefixes.
 */
#define PROJECT_CVAR_PREFIX PROJECT_SHORTNAME
#define PROJECT_CMD_PREFIX  PROJECT_SHORTNAME


// **********************************************
//            Translations Manager
// **********************************************

/**
 * Exvel's chat color include is supported by the translations manager.
 * Include the color.inc file below and TransMgr_PrintText* will support the color tags.
 * 
 * Link to colors on SM forums: http://forums.alliedmods.net/showthread.php?t=96831
 */
#include <colors>

/**
 * The directory where the project's translation files will be in.
 * All translations files in the format of *.phrases.txt will be automatically loaded.
 * Example path: addons/sourcemod/translations/TM_BASE_DIR/projectbase.phrases.txt.
 * If the resulting path doesn't exist, errors will be logged.
 * 
 * Comment the define out to disable auto-loading.  See stock Project_LoadExtraTranslations.
 * 
 * Note: This only used if translationsmanager.inc is included.
 */
#define TM_BASE_DIR PROJECT_SHORTNAME

/**
 * The formatting string for each option in enum MsgFormatting.
 * Note: These are only used if translationsmanager.inc is included.
 * 
 * See TransMgr_PrintText in translationsmanager.inc.
 * 'translated': The translated text being printed.
 * 'modulefullname': The module's full name.
 * 
 * Color chars vary from game to game.
 */
#define TM_MSGFORMAT_PLUGIN_COLOR      "\x04[%s]\x01 %s", PROJECT_PRINT_FULLNAME, translated
#define TM_MSGFORMAT_PLUGIN_NOCOLOR    "[%s] %s", PROJECT_PRINT_FULLNAME, translated
#define TM_MSGFORMAT_MODULE_COLOR      "\x03[%s]\x01 %s", modulefullname, translated
#define TM_MSGFORMAT_MODULE_NOCOLOR    "[%s] %s", modulefullname, translated
#define TM_MSGFORMAT_BOTH_COLOR        "\x04[%s::\x03%s]\x01 %s", PROJECT_PRINT_FULLNAME, modulefullname, translated
#define TM_MSGFORMAT_BOTH_NOCOLOR      "[%s::%s] %s", PROJECT_PRINT_FULLNAME, modulefullname, translated

/**
 * Load any extra translation files here.
 * This is also called when translations are being reloaded mid-game.
 *  
 * If TM_BASE_DIR is defined, all translations files in the format of *.phrases.txt will be
 * automatically loaded from the "translations/TM_BASE_DIR/" dir.
 * 
 * Note: If the translations manager isn't included, you must load all your translations here.
 * 
 * @param transmanagerloaded    True if the translations manager is loaded, false if not.
 */
stock Project_LoadExtraTranslations(bool:transmanagerloaded)
{
    // Load translations we may need, if the translations manager isn't loaded.
    if (!transmanagerloaded)
    {
        LoadTranslations("projectbase.phrases");
        
        #if defined PROJECT_BASE_CMD
            LoadTranslations("basecmd.phrases");
        #endif
    }
    
    // Standard phrases provided by SM.
    LoadTranslations("common.phrases");
}


// **********************************************
//                 Log Manager
// **********************************************

/**
 * The formatting string for all logs.
 * Note: This is only used if logmanager.inc is included.
 *  
 * See LogMgr_Print in logmanager.inc.
 * 'modulefullname': The module's full name.
 * 'description': The log description.
 * 'logbuffer': The log text.
 */
#define LM_FORMAT "[%s] [%s] %s", modulefullname, description, logbuffer


// Access Manager

/**
 * The formatting string for module access groups/cvars.
 * Note: This is only used if accessmanager.inc is included.
 *  
 * See AccessMgr_ModuleToGroupName and AccessMgr_ModuleToCvarName in accessmanager.inc.
 * 'moduleshortname':  The short name of the module the group/cvar name is being formatted for.
 */
#define AM_FORMAT_GROUP "%s_access_%s", PROJECT_CVAR_PREFIX, moduleshortname
#define AM_FORMAT_CVAR  "%s_access_%s", PROJECT_CVAR_PREFIX, moduleshortname

// **********************************************
//                Version Info
// **********************************************

/**
 * If this is defined, then it should be in a mercurial repository.
 */
//#define PROJECT_MERCURIAL

// Name of the Mercurial branch this is being developed in.
#define PROJECT_BRANCH "default"

/**
 * Name of the public cvar for the plugin.
 * Comment this define out to not create a public cvar.
 */
#define PROJECT_PUBLIC_CVAR "thc_rpg_version"
